
#include "parameters_sweeps.h"


int main(int argc, const char * argv[]) {
    
    //basic parameters for the simulation
    constexpr int number_of_ens=1024;
    
    constexpr int ring_size=60;
    
    constexpr long initial_particle_number=1;
    
    constexpr double decat_rate=0.0;
    constexpr double activation_rate=100000;
    constexpr double dimerzation_rate=1;
    
    constexpr bool record_time_trace=false;
    constexpr double time_steps=1;
    
    //output names
    std::string time_trace_file_name("time_traces_dimerization_rate.hdf5");
    std::string parameter_sweep_file_name("parameter_sweep");
    
    //values for all binding events
    std::array<double, ring_size-1> reaction_rates;
    for (auto& x : reaction_rates) {
        x=1.0;
    }
    reaction_rates[0]=dimerzation_rate;
    
    //handel termination signals. useful for runs on a cluster etc.
    signal (SIGTERM, StopBecauseOfException);
    signal (SIGINT, StopBecauseOfException);
    
    //store data in case rescue is needed
    std::vector<double> results;
    data_which_can_be_rescued=&results;
    
    //file for final results
    H5::H5File file(time_trace_file_name.data(),H5F_ACC_TRUNC);
    time_traces_which_can_be_rescued=&file;
    
    //set up parameter sweep
    ParameterSweep<ring_size> system(initial_particle_number,activation_rate,dimerzation_rate,decat_rate,reaction_rates,record_time_trace,time_steps,time(nullptr));
    
    //perform parameters sweep for dimerization rate
    system.SetSweepRange(DimerizationRate, 0.00001, 10, 1.5);

    //perform sweep
    system.Sweep<ring_size, 2>(number_of_ens,results,file);
    
    //save data
    Write2DVectorToHDF5(results,8,parameter_sweep_file_name);
    file.close();
    
    return 0;
}
